/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1.parts;

import com.roguewave.chart.core.v2_1.graphics.Canvas3D;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.standard.v2_1.Chart;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;

public class RescalerDrawable
implements Drawable {
    String[] strings_;
    Font font_;
    Point3D[] bounds_;

    public RescalerDrawable(String[] strings, Font font, Point3D[] bounds) {
        this.strings_ = strings;
        this.font_ = font;
        this.bounds_ = bounds;
    }

    public RescalerDrawable(Font font, Point3D[] bounds) {
        this(null, font, bounds);
    }

    public void drawOn(Canvas3D canvas, Graphics g) {
        if (!(canvas instanceof Chart)) {
            return;
        }
        FontMetrics metrics = g.getFontMetrics(this.font_);
        int max = 0;
        if (this.strings_ != null) {
            for (int i = 0; i < this.strings_.length; ++i) {
                int length = metrics.stringWidth(this.strings_[i]);
                if (length <= max) continue;
                max = length;
            }
        }
        Insets insets = (Insets)((Chart)canvas).getDrawAreaInsets().clone();
        insets.left += max + 4;
        insets.bottom += metrics.getHeight() + 4;
        insets.top += metrics.getHeight() / 2;
        canvas.setBoundingWindow(this.bounds_, insets);
    }
}

